<?php
/**
 * _tk functions and definitions
 *
 * @package _tk
 */

 /**
  * Store the theme's directory path and uri in constants
  */
 define('THEME_DIR_PATH', get_template_directory());
 define('THEME_DIR_URI', get_template_directory_uri());

/**
 * Create custom stylesheet from php file with ACF fields.
 */
 function generate_options_css() {
    $ss_dir = get_stylesheet_directory();
    ob_start();
    require($ss_dir . '/includes/custom-styles.php');
    $css = ob_get_clean();
    file_put_contents($ss_dir . '/includes/css/custom-styles.css', $css, LOCK_EX);
}
add_action( 'acf/save_post', 'generate_options_css' );

 /**
 * Check if color is rather dark or light
 */
function colorContrast($hexcolor){
	$hexcolor = str_replace('#', '', $hexcolor);
	$r = hexdec(substr($hexcolor,0,2));
	$g = hexdec(substr($hexcolor,2,2));
	$b = hexdec(substr($hexcolor,4,2));
	$col = (($r*299)+($g*587)+($b*114))/1000;
	return ($col < 128) ? 'dark' : 'light';
}

/* Remove the […] in a Read More link */
if( !function_exists( "pro_excerpt_more" ) ) {
  function pro_excerpt_more( $more ) {
    global $post;
	if (get_field('excerpt_btn_type','option') == 'text')
		return '... <a href="'. get_permalink($post->ID) . '" class="btn-excerpt" title="'.get_the_title($post->ID).'">'.__( 'Continue reading', '_tk' ) .'<span class="meta-nav">&rarr;</span></a>';
	else
		return '...<br/><a href="'. get_permalink($post->ID) . '" class="btn btn-primary btn-primary-excerpt" title="'.get_the_title($post->ID).'">'.__( 'Continue reading', '_tk' ) .'</a>';
  }
}
add_filter('excerpt_more', 'pro_excerpt_more');

 /**
 * Set the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) )
	$content_width = 750; /* pixels */

if ( ! function_exists( '_tk_setup' ) ) :
/**
 * Set up theme defaults and register support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 */
function _tk_setup() {
	global $cap, $content_width;

	// Add html5 behavior for some theme elements
	add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption' ) );

    // This theme styles the visual editor with editor-style.css to match the theme style.
	add_editor_style();

	/**
	 * Add default posts and comments RSS feed links to head
	*/
	add_theme_support( 'automatic-feed-links' );

	/**
	 * Enable support for Post Thumbnails on posts and pages
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	*/
	add_theme_support( 'post-thumbnails' );

	/**
	 * Enable support for Post Formats
	*/
	add_theme_support( 'post-formats', array( 'gallery', 'video', 'quote', 'link', 'aside' ) );

	/**
	 * Setup the WordPress core custom background feature.
	*/
	add_theme_support( 'custom-background', apply_filters( '_tk_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
		) ) );

	/**
	 * Make theme available for translation
	 * Translations can be filed in the /languages/ directory
	 * If you're building a theme based on _tk, use a find and replace
	 * to change '_tk' to the name of your theme in all the template files
	*/
	load_theme_textdomain( '_tk', THEME_DIR_PATH . '/languages' );

	/**
	 * This theme uses wp_nav_menu() in one location.
	*/
	if (get_field('nav_center','option') and get_field('nav_center_menu','option') == 'double') {
    register_nav_menus( array(
  		'primary'  => __( 'Header menu - left', '_tk' ),
  		'primary2'  => __( 'Header menu - right', '_tk' ),
  		'footer'  => __( 'Footer menu', '_tk' ),
  	) );
  } else {
    register_nav_menus( array(
  		'primary'  => __( 'Header menu', '_tk' ),
  		'footer'  => __( 'Footer menu', '_tk' ),
  	) );
  }

}
endif; // _tk_setup
add_action( 'after_setup_theme', '_tk_setup' );

/* Global variables */
$section = 1;

/**
 * Menus
 */
if (get_field('nav_center','option') and get_field('nav_center_menu','option') == 'double') {
  function pro_main_nav() {
  	wp_nav_menu(
  		array(
  			'theme_location' 	=> 'primary',
  			'depth'             => 4,
  			'container'         => '',
  			'container_class'   => '',
  			'menu_class' 		=> 'nav navbar-nav navbar-left',
  			'fallback_cb' 		=> 'wp_bootstrap_navwalker::fallback',
  			'menu_id'			=> 'main-menu',
  			'walker' 			=> new wp_bootstrap_navwalker()
  		)
  	);
  }
} else {
  function pro_main_nav() {
    wp_nav_menu(
      array(
        'theme_location' 	=> 'primary',
        'depth'             => 4,
        'container'         => '',
        'container_class'   => '',
        'menu_class' 		=> 'nav navbar-nav navbar-right',
        'fallback_cb' 		=> 'wp_bootstrap_navwalker::fallback',
        'menu_id'			=> 'main-menu',
        'walker' 			=> new wp_bootstrap_navwalker()
      )
    );
  }
}
function pro_main2_nav() {
	wp_nav_menu(
		array(
			'theme_location' 	=> 'primary2',
			'depth'             => 4,
			'container'         => '',
			'container_class'   => '',
			'menu_class' 		=> 'nav navbar-nav navbar-left',
			'fallback_cb' 		=> 'wp_bootstrap_navwalker::fallback',
			'menu_id'			=> 'main-menu',
			'walker' 			=> new wp_bootstrap_navwalker()
		)
	);
}
function pro_footer_nav() {
	wp_nav_menu(
		array(
			'theme_location' 	=> 'footer',
			'depth'             => 0,
			'container'         => 'div',
			'container_class'   => 'footer-menu row',
			'menu_class' 		=> 'nav navbar-nav navbar-left wow fadeInUp',
			'fallback_cb' 		=> 'wp_bootstrap_navwalker::fallback',
			'menu_id'			=> 'footer-menu',
			'walker' 			=> new wp_bootstrap_navwalker()
		)
	);
}

 /**
 * Enqueue scripts and styles
 */
function _tk_scripts() {

	// Import the necessary TK Bootstrap WP CSS additions
	wp_enqueue_style( '_tk-bootstrap-wp', THEME_DIR_URI . '/includes/css/bootstrap-wp.css' );

	// load bootstrap css
	wp_enqueue_style( '_tk-bootstrap', THEME_DIR_URI . '/includes/resources/bootstrap/css/bootstrap.min.css' );

	// load Owl Carousel
	wp_enqueue_style( 'owl-carousel', THEME_DIR_URI . '/includes/css/owl.carousel.css' );

	// load animatecss
	wp_enqueue_style( 'animate', THEME_DIR_URI . '/includes/css/animate.css' );

	// load Font Awesome css
	wp_enqueue_style( '_tk-font-awesome', THEME_DIR_URI . '/includes/css/font-awesome.min.css', false, '4.7.0' );

	// load _tk styles
	wp_enqueue_style( '_tk-style', get_stylesheet_uri() );

	// load custom css
	wp_enqueue_style( 'custom-styles', THEME_DIR_URI . '/includes/css/custom-styles.css' );

	// load project css
	wp_enqueue_style( 'style-project', THEME_DIR_URI . '/includes/css/style-project.css' );

	// load bootstrap js
	wp_enqueue_script('_tk-bootstrapjs', THEME_DIR_URI . '/includes/resources/bootstrap/js/bootstrap.min.js', array('jquery'), '' , true );

	// load bootstrap wp js
	wp_enqueue_script( '_tk-bootstrapwp', THEME_DIR_URI . '/includes/js/bootstrap-wp.js', array('jquery'), '' , true );

	wp_enqueue_script( '_tk-skip-link-focus-fix', THEME_DIR_URI . '/includes/js/skip-link-focus-fix.js', array(), '20130115', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	if ( is_singular() && wp_attachment_is_image() ) {
		wp_enqueue_script( '_tk-keyboard-image-navigation', THEME_DIR_URI . '/includes/js/keyboard-image-navigation.js', array( 'jquery' ), '20120202', true );
	}

	// load Owl scripts
	wp_enqueue_script( 'owl-script', THEME_DIR_URI . '/includes/js/owl.carousel.min.js', array(), '', true );
	
	// load Nice scroll
	wp_enqueue_script( 'nice-scroll', THEME_DIR_URI . '/includes/js/jquery.nicescroll.min.js', array(), '', true );
	
	// load Same height
	wp_enqueue_script( 'matchheight', THEME_DIR_URI . '/includes/js/jquery.matchHeight.js', array(), '', true );
	
	// load Popup
	wp_enqueue_script( 'cookie', THEME_DIR_URI . '/includes/js/js.cookie.js', array(), '', true );
	wp_enqueue_script( 'popup', THEME_DIR_URI . '/includes/js/popup.js', array(), '', true );

	// load wow
	if (get_field('start_wow','option')) wp_enqueue_script( 'wowjs', THEME_DIR_URI . '/includes/js/wow.min.js', array(), '', true );

	// load CoveringBad - compare two photos
	wp_enqueue_script( 'covering-bad', THEME_DIR_URI . '/includes/js/coveringBad.js', array(), '', true );
	
	// load mobile custom
	wp_enqueue_script( 'mobile', THEME_DIR_URI . '/includes/js/jquery.mobile.custom.min.js' );
	
	// load Konva canvas
	wp_enqueue_script( 'konva', THEME_DIR_URI . '/includes/js/konva.min.js' );

	// load Masonry
	wp_enqueue_script( 'masonry', THEME_DIR_URI . '/includes/js/masonry.pkgd.min.js', array(), '', true );
	wp_enqueue_script( 'isotope', THEME_DIR_URI . '/includes/js/isotope.pkgd.min.js', array(), '', true );
	wp_enqueue_script( 'imagesloaded', THEME_DIR_URI . '/includes/js/imagesloaded.pkgd.min.js', array(), '', true );
	
	// load Gridder - expand gallery
	wp_enqueue_script( 'grider', THEME_DIR_URI . '/includes/js/jquery.gridder.min.js', array(), '', true );
	
	// load CounterUp
	wp_enqueue_script( 'counterup', THEME_DIR_URI . '/includes/js/jquery.counterup.min.js', array(), '', true );

	// ACF Map
	if (get_field('google_api','option')) {
		wp_enqueue_script( 'google-map', 'https://maps.googleapis.com/maps/api/js?key=' . get_field('google_api','option'), array(), '', true );
		wp_enqueue_script( 'acf-map', THEME_DIR_URI . '/includes/js/acf-map.js', array(), '', true );
	}

	wp_enqueue_script( 'functions', THEME_DIR_URI . '/includes/js/functions.js', array(), '', true );
	
	if (is_singular(array('buildings')) or is_tax('apartment_category')) {
		wp_enqueue_script( 'stickyInvestment', THEME_DIR_URI . '/includes/js/stickyInvestment.js', array(), '', true );
	}
	
	// inicialize wow
	if (get_field('start_wow','option')) {
		wp_enqueue_script( 'wow-start', THEME_DIR_URI . '/includes/js/wow-start.js', array(), '', true );
	}

}
add_action( 'wp_enqueue_scripts', '_tk_scripts' );

/**
 * Options page - ACF
 */
if( function_exists('acf_add_options_page') ) {

	acf_add_options_page(array(
		'page_title' 	=> 'Opcje główne',
		'menu_title'	=> 'Opcje',
		'menu_slug' 	=> 'general-settings',
		'capability'	=> 'edit_posts',
		'redirect'		=> false
	));

	acf_add_options_sub_page(array(
		'page_title' 	=> 'Opcje dodatkowe',
		'menu_title'	=> 'Opcje dodatkowe',
		'parent_slug'	=> 'general-settings',
	));

}

// Allow SVG through WordPress Media Uploader
function cc_mime_types($mimes) {
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');

// Navigation between taxonomy pages
class wpse_99513_adjacent_category {

    public $sorted_taxonomies;

    /**
     * @param string Taxonomy name. Defaults to 'category'.
     * @param string Sort key. Defaults to 'id'.
     * @param boolean Whether to show empty (no posts) taxonomies.
     */
    public function __construct( $taxonomy = 'category', $order_by = 'id', $skip_empty = true ) {

        $this->sorted_taxonomies = get_terms(
            $taxonomy,
            array(
                'get'          => $skip_empty ? '' : 'all',
                'fields'       => 'ids',
                'hierarchical' => false,
                'order'        => 'ASC',
                'orderby'      => $order_by,
            )
        );
    }

    /**
     * @param int Taxonomy ID.
     * @return int|bool Next taxonomy ID or false if this ID is last one. False if this ID is not in the list.
     */
    public function next( $taxonomy_id ) {

        $current_index = array_search( $taxonomy_id, $this->sorted_taxonomies );

        if ( false !== $current_index && isset( $this->sorted_taxonomies[ $current_index + 1 ] ) )
            return $this->sorted_taxonomies[ $current_index + 1 ];

        return false;
    }

    /**
     * @param int Taxonomy ID.
     * @return int|bool Previous taxonomy ID or false if this ID is last one. False if this ID is not in the list.
     */
    public function previous( $taxonomy_id ) {

        $current_index = array_search( $taxonomy_id, $this->sorted_taxonomies );

        if ( false !== $current_index && isset( $this->sorted_taxonomies[ $current_index - 1 ] ) )
            return $this->sorted_taxonomies[ $current_index - 1 ];

        return false;
    }
}

// Custom order of product of taxonomy page
add_action( 'pre_get_posts', 'apartment_taxonomy_archive_display' );
function apartment_taxonomy_archive_display ( $query ) {
    if (is_tax('product_category')){
		$query->set( 'orderby', 'menu_order' );
		$query->set( 'order', 'ASC' );
		$query->set( 'posts_per_page', '-1' );
	}
}

// Custom style for backend
add_action('admin_head', 'my_custom_fonts');

function my_custom_fonts() {
  echo '<style>
    #edittag {
      max-width: none;
    } 
  </style>';
}


// get top-level parent of term
function get_term_top_most_parent($term_id, $taxonomy){
    // start from the current term
    $parent_term  = get_term_by( 'id', $term_id, $taxonomy);
    // climb up the hierarchy until we reach a term with parent = '0'
    while ($parent_term->parent != '0'){
        $term_id = $parent_term->parent;

        $parent_term  = get_term_by( 'id', $term_id, $taxonomy);
    }
    return $parent_term;
}

 /**
 * Customize login form
 */
function my_login_stylesheet() {
    wp_enqueue_style( 'custom-login', get_stylesheet_directory_uri() . '/includes/css/style-login.css' );
}
add_action( 'login_enqueue_scripts', 'my_login_stylesheet' );

/**
 * Implement the Custom Header feature.
 */
require THEME_DIR_PATH . '/includes/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require THEME_DIR_PATH . '/includes/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require THEME_DIR_PATH . '/includes/extras.php';

/**
 * Customizer additions.
 */
require THEME_DIR_PATH . '/includes/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require THEME_DIR_PATH . '/includes/jetpack.php';

/**
 * Load custom WordPress nav walker.
 */
require THEME_DIR_PATH . '/includes/bootstrap-wp-navwalker.php';

/**
 * Load widgets.
 */
require THEME_DIR_PATH . '/includes/widgets.php';

/**
 * Load custom post type
 */
require THEME_DIR_PATH . '/includes/custom-post-type.php';
